
markup.push({

// MARK: templates window

TemplatesWindow:
{
	nsClass: "GXWindow",
	gxInitialWindowSize: "740, 615",	 // approx, for initial positioning
	gxWindowMaxSize: "740, 1200",
	gxWindowMinSize: "740, 250",
	gxInitialWindowPosition: "0.7, 0.5",
	gxWindowTitle: "Template Chooser",
	gxSavedWindowStateKey: "templatesWindow",
	gxContentView: "TemplatesWindowContentView",
},

// MARK: content view

TemplatesWindowContentView:
{
	nsClass: "GXDrawView",
	gxWantsLayer: true,
	gxLayout: [
		"H:[self(740)]",		// sets window width

		"V:[titleBarView(26)]-0-[headerView(38)]-0-[divider(1)]-0-[templatesScrollView]-0-[bottomBar(41)]|", // sets window height, space for list fixed

		"H:|-0-[headerView]-0-|",
		"H:|-0-[divider]-0-|",
	],
	gxChildViews:
	{
		titleBarView:
		{
			"+": "TitleBarView",
			gxChildViews:
			{
				windowTitle: {
					"+": "WindowTitle",
					gxDefaultValue: "Template Chooser",
				},
			},
		},
		headerView: {	 // whole header is an oversized overcustomised label
			"+": "LabelView",
			gxDefaultValue: "Choose a Session Template",
			axIsIgnored: false,
			gxForePainter: {
				"+": "LabelFore.left.centery.size20",
				gxEdgeInsets: "30, 0, 0, 2"
			},
			gxBackPainter: fillPainter("BackColor1"),
		},
		divider: filledView("BackColor3"),
		templatesScrollView:
		{
			nsClass: "GXScrollView",
			gxBackColor: "BackColor1",
			gxVScrollbar: "ScrollBarView",	// vertical scroller only
			gxAddViewBelow: true,
			gxLayout: [ "H:|-0-[self]-0-|" ],
			gxDocumentView:
            {
				nsClass: "GXFlowView",
				gxViewName: "templatesList",
				gxValueKey: "templateSessions",
				gxListItemView: "TemplateSessionItem",
				axTitle: "Templates",
				axHelp: "List of template sessions",
				gxLayout: [ "H:|-0-[self]-0-|" ],
			},
		},
		bottomBar:
		{
			nsClass: "GXDrawView",
			gxBackPainter: "BottomBarBack",
			gxLayerZPosition: 1,
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				"H:[chooseBtn(100)]-14-|&alignCenterY",
				"H:[self]-(<=0)-[chooseBtn]&alignCenterY" // center vertically trick
			],
			gxChildViews:
			{
				chooseBtn:
				{
					"+": "ButtonView",
					gxTitle: "Choose",
					gxValueKey: "chooseBtn",
					gxIntrinsicHeight: 25,
					axIsIgnored: true,
				}
			}
		}
	}
},

	
// MARK: template list item

TemplateSessionItem:
{
	nsClass: "GXListItemView",
	gxIntrinsicWidth: 180,
	gxIntrinsicHeight: 156,
	gxSelectable: 1,	// single selectable
	gxDoubleClickKey: "templateItemDoubleClick",
	axIsIgnored: false,
	axTitleKeyPath: "name",
    axRoleDescription: "Template Session",
    axDescriptionKeyPath: "templateSubtitle",
    axHelp: "VO press to create a new session based on this template",
	gxLateLayout: [
		"H:|-(-999)-[self(180)]",		// h position set by parent
		"V:|-(-999)-[self(156)]",		// v position set by parent
	],
	gxChildViews:
	{
		icon: {
			nsClass: "GXDrawView",
			gxForePainter:
			{
				"+": "ImagePainter",
				gxTintColor: "ColorTheme1",
				selected: {
					gxTintColor: "ColorLive1.noLightMode",	// always orange
				},
			},
			gxDisplayValueKey: "templateIconName",
			gxFrameRect: "20,0,140,100"
		},
		title: {
			"+": "LabelView.mediumWeight.foreColor1.size14",
			gxValueKey: "name",
			gxLineBreakMode: 0,	// word wrap, not default truncate tail.
			gxFrameRect: "5,100,170,18"
		},
		description: {
			"+": "LabelView.thinWeight.top.wrap.foreColor1.size12",
			gxValueKey: "templateSubtitle",
			gxFrameRect: "10,120,160,68"
		}
	}
},

})
